/*
 * Decompiled with CFR 0.152.
 */
package apicore.ptmp;

import apicore.message.IPCEventLTV;
import apicore.message.LTV;
import apicore.ptmp.PacketTracerSession;
import apicore.ptmp.Pipeline;
import apicore.util.Logger;
import apicore.util.Pair;
import apicore.util.Utilities;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;

public class PacketTracerReadWorker
extends Thread {
    protected PacketTracerSession session;
    protected Pipeline pipeline;
    protected Map<Integer, Pair<Semaphore, LTV>> waiters = new HashMap<Integer, Pair<Semaphore, LTV>>();
    protected boolean shouldStop = false;

    public PacketTracerReadWorker(PacketTracerSession packetTracerSession, Pipeline pipeline) {
        this.session = packetTracerSession;
        this.pipeline = pipeline;
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public void registerRequest(LTV lTV) {
        if (!lTV.hasResponse()) {
            throw new Error("Attempt to register an LTV with no response; LTV = " + lTV);
        }
        this.registerRequest(lTV.getMessageId());
    }

    public void registerRequest(int n) {
        Pair pair = new Pair();
        Semaphore semaphore = new Semaphore(0, true);
        pair.setFirst(semaphore);
        this.waiters.put(n, pair);
    }

    public LTV getResponse(LTV lTV) {
        if (!lTV.hasResponse()) {
            throw new Error("Attempt to get a response for an LTV with no response; LTV = " + lTV);
        }
        return this.getResponse(lTV.getMessageId());
    }

    public LTV getResponse(int n) {
        Pair<Semaphore, LTV> pair = this.waiters.get(n);
        if (pair == null) {
            throw new Error("Attempt to get a response for an unregistered Message ID = " + n);
        }
        try {
            pair.getFirst().acquire();
        }
        catch (InterruptedException interruptedException) {
            this.waiters.remove(n);
            return null;
        }
        this.waiters.remove(n);
        return pair.getSecond();
    }

    public void shouldStop() {
        this.shouldStop = true;
        this.interrupt();
    }

    public void run() {
        while (!this.shouldStop) {
            try {
                LTV lTV = this.pipeline.read();
                if (lTV == null) {
                    Logger.info("PacketTracerReadWorker: Null inbound LTV; will be ignored.");
                    continue;
                }
                if (lTV.isResponse() || lTV.isError()) {
                    Pair<Semaphore, LTV> pair = this.waiters.get(lTV.getMessageId());
                    if (pair != null) {
                        pair.setSecond(lTV);
                        ((Semaphore)pair.getFirst()).release();
                        continue;
                    }
                    this.discardUnmatchedResponse(lTV);
                    continue;
                }
                if (lTV.isEvent()) {
                    this.session.handleEvent((IPCEventLTV)lTV);
                    continue;
                }
                if (lTV.isMuMessage()) {
                    this.session.handleMuMessage(lTV);
                    continue;
                }
                this.discardUnknownMessage(lTV);
            }
            catch (IOException iOException) {
                try {
                    for (Pair<Semaphore, LTV> pair : this.waiters.values()) {
                        pair.getFirst().release();
                    }
                }
                catch (Throwable throwable) {
                    Utilities.check(throwable);
                    Logger.error("Exception releasing waiters: " + throwable.getMessage());
                }
                this.session.readWorkerError(iOException);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Throwable throwable) {
                Utilities.check(throwable);
                this.session.readWorkerError(throwable);
            }
        }
    }

    protected void discardUnmatchedResponse(LTV lTV) {
        Logger.info("Response with no pending request received.  ID = " + lTV.getMessageId() + "; LTV = " + lTV);
    }

    protected void discardUnknownMessage(LTV lTV) {
        Logger.info("Unrecognized kind of message read.  ID = " + lTV.getMessageId() + "; Type = " + lTV.getType() + "; LTV = " + lTV);
    }
}

